﻿// КОНВЕРТИРУЕМ СТРОКУ С 60-РИЧНЫМ ЧИСЛОМ В
// В ДЕСЯТИЧНОЕ ЧИСЛО
function Get60(s60 : string) : integer;
begin
   var res := 0;
   // разбиваем строку по точкам:
   var str := s60.Split(['.']);

   // вычисляем десятичное число:
   var k := 1;
   for var i := str.Length - 1 downto 0 do begin
      res += Convert.ToInt32(str[i]) * k;
      k *= 60;
   end;
   Result := res;
end;
    
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   var vars60 := [ '1.21', '9',
                   '2.1', '11',
                   '2.49', '13',
                   '3.45', '15',
                   '4.16', '16',
                   '25.21', '39',
                   '56.4', '58' ];
   for var i := 0 to vars60.Length-1 step 2 do begin
       // 60-ричное число:
       var s60 := vars60[i];
       // конвертируем в десятичное
       var n60 := Get60(s60);
       // квадрат:
       var n := Convert.ToInt32(vars60[i + 1]);
       var n2 := n * n;
       var answer := '';
       // проверяем условия:
       if (n60 = n2) then
           answer := $' 60-ричное число {s60} ({n60}) равно {n} в квадрате ({n2})'
       else
           answer := $' 60-ричное число {s60} равно {n} в квадрате ({n2})';
       Writeln(answer);
   end;
end;


procedure Solve2();
begin
   var vars60 := [ '2.5', '5',
                   '3.36', '6',
                   '5.43', '7',
                   '8.32', '8',
                   '1.8.16', '16',
                   '9.6.8', '32'  ];
   for var i := 0 to vars60.Length-1 step 2 do begin
       // 60-ричное число:
       var s60 := vars60[i];
       // конвертируем в десятичное
       var n60 := Get60(s60);
       // куб:
       var n := Convert.ToInt32(vars60[i + 1]);
       var n3 := n * n * n;
       var answer := '';
       // проверяем условия:
       if (n60 = n3) then
           answer := $' 60-ричное число {s60} ({n60}) равно {n} в кубе ({n3})'
       else
           answer := $' 60-ричное число {s60} равно {n} в кубе ({n3})';
       Writeln(answer);
   end;
end;

begin
   Writeln(' Вавилонские квадраты и кубы');
   Writeln(' Наука и жизнь 1963-03-38-5');  
   Writeln; 
   Solve(); Writeln; 
   Solve2(); Writeln;    
end.
